function [rx_packages_to_demod] = averaging_channel_estimate_without_OFDM(rx_demod,rx_training_symbols)

length_training = length(rx_training_symbols);
length_rx_packages = length(rx_demod);

% Picks out the the training sequence
C1=[rx_demod(1:length_training)'];

% The whole package
C2 = [rx_demod'];

% Here we choose the number of taps:
taps = 8; %11;

for i=1:(taps-1)
    
    %This for-loop builds two matrices of "sample shifted" signals i.e. the
    %matrix A would for a small vector v = (1 2 3) with three taps look
    %like A = (1 2 3; 0 1 2; 0 0 1)
    
    %This is the matrix that we use with the training segment
    %in order to create the equalizer.

    C1=[C1,[zeros(i,1);rx_demod(1:length_training-i)']];
    
    %This is the matrix that the equalizer is used upon to restore
    %the package. Here the whole package is used.
   
    C2=[C2,[zeros(i,1);rx_demod(1:length_rx_packages-i)']];
    
end

%Creates the equalizer g with the least square method
g=C1\rx_training_symbols';
%Restore the package
rx_packages_to_demod = (C2*g)';

end




